/* whiteLABEL TEN:Q - TEN BAND EQ PLUGIN */
/* http://www.roughdiamondproductions.com/whiteLABEL */
 
/* VUDUAL VERTEX SHADER */
 
uniform float height;
uniform int stage;
uniform float level;

uniform float HUE;
uniform float SATURATION;
uniform float LIGHTNESS;

uniform int MODE;
uniform int CHANNEL;
uniform int MONOCHROME;
uniform int BLEND;
 
float HUE2RGB(in float p, in float q, in float t){
	
	if(t < 0.0) t += 1.0;
	if(t > 1.0) t -= 1.0;
	if(t < 1.0/6.0) return p + (q - p) * 6.0 * t;
	if(t < 1.0/2.0) return q;
	if(t < 2.0/3.0) return p + (q - p) * (2.0/3.0 - t) * 6.0;
	return p;
}

void HLS2RGB(in float hue, in float saturation, in float lightness, out float red, out float green, out float blue){

	float q;
	float p;

    if(saturation == 0.0){	// achromatic
        red = lightness;
        green = lightness;
        blue = lightness;
    }else{


        q = lightness < 0.5 ? lightness * (1.0 + saturation) : lightness + saturation - lightness * saturation;
        p = 2.0 * lightness - q;
        red = HUE2RGB(p, q, hue + 1.0/3.0);
        green = HUE2RGB(p, q, hue);
        blue = HUE2RGB(p, q, hue - 1.0/3.0);
    }
}

void main(void)
{
	vec4 v = vec4(gl_Vertex); 
	vec4 c,b;
        
	float h = (2.0/3.0) - (1.0-(v.y/height))*(2.0/3.0);
	float red;
	float green;
	float blue;
	float hue = HUE;
	switch(MODE){
	case 0:
	if(MONOCHROME == 1){
		if(BLEND == 1){
			if(v.y<0.0){
			hue -= v.y * 0.005;
			}else{
			hue += v.y * 0.0005;
			}
			while(hue > 0.5){
				hue -=1.0;
			}
			while(hue < -0.5){
				hue +=1.0;
			}
		}
		HLS2RGB(hue,SATURATION,0.5+LIGHTNESS,red,green,blue);
	}else{
		HLS2RGB(h+HUE,SATURATION,0.5+LIGHTNESS,red,green,blue);
		}

		c.r = red;
		c.g = green;
		c.b = blue;
		c.a = 1.0;

		break;
		case 1:
		switch(CHANNEL){
			case 1:
				c.a=0.8;
				c.r=1.0;
				c.g=1.0;
				c.b=0.0;
			break;
			case 2:
				c.a=0.8;
				c.r=0.0;
				c.g=1.0;
				c.b=0.0;
			break;
		}
		break;
		case 2:
		switch(CHANNEL){
			case 1:
			c.r = 1.0;
			c.g = 0.0;
			c.b = 1.0;
			c.a = 0.8;
			break;
			case 2:
				c.r = 0.0;
			c.g = 1.0;
			c.b = 1.0;
			c.a = 0.8;
			break;
		}

		break;
	}

	// HLS2RGB(HUE,SATURATION,LIGHTNESS,red,green,blue);
        


			b.r = 0.3;
			b.g = 0.3;
			b.b = 0.3;
			b.a = 0.1;
	
	gl_Position = gl_ModelViewProjectionMatrix * v;  
	
	  
	if(stage == 0){
		gl_FrontColor = c;
		gl_BackColor = c;
	}else{
		//gl_Color = b;
		gl_FrontColor = b;
		gl_BackColor = b;
	}
	

	    
}

